-- Function to determine the energy impacts for measures based on existing technology and IP runs
-- 
-- all measure IDs in the table msrs2proc will be processed
-- returns total number of records processed
DECLARE
    MeasIDs "simresults"."msrs2proc"%ROWTYPE;
    TotProc INTEGER;
    OneProc INTEGER;
    TotalToProc INTEGER;
BEGIN
 TotProc = 0;
 TotalToProc = (Select COUNT(*) from simresults.msrs2proc where include = TRUE);
 FOR MeasIDs IN SELECT * FROM simresults.msrs2proc where include = TRUE
  LOOP
   OneProc = simresults."CalcImpactsForMeasID_Wtd"(MeasIDs.measure_id::text); 
   TotProc = TotProc + 1;
   RAISE INFO 'completed % of %, added % records', TotProc, TotalToProc,OneProc;
  END LOOP;
 RETURN TotProc;
END;
